/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.calculation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.experience.calculation.parameter.Parameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.experience.calculation.Calculation;

public class CalculationManager<T> {
    private final Map<String, Condition<T>> conditions;
    private final Map<String, Parameter<T>> parameters;
    private final List<Calculation> calculations;

    private CalculationManager(Map<String, Condition<T>> conditions, Map<String, Parameter<T>> parameters, List<Calculation> calculations) {
        this.conditions = conditions;
        this.parameters = parameters;
        this.calculations = calculations;
    }

    public int getValue(T t) {
        Map<String, Boolean> conditionsVariables = this.conditions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Condition)entry.getValue()).test(t)));
        Map<String, Double> expressionVariables = this.parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Double)((Parameter)entry.getValue()).apply(t)));
        return this.calculations.stream().flatMap(calc -> calc.getValue(conditionsVariables, expressionVariables).stream()).findFirst().orElse(0);
    }

    public static <T> Result<CalculationManager<T>, Failure> create(JsonElementWrapper rootElement, Map<String, ConditionFactory<T>> conditionFactories, Map<String, ParameterFactory<T>> parameterFactories, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> CalculationManager.create(rootObject, conditionFactories, parameterFactories, context));
    }

    public static <T> Result<CalculationManager<T>, Failure> create(JsonObjectWrapper rootObject, Map<String, ConditionFactory<T>> conditionFactories, Map<String, ParameterFactory<T>> parameterFactories, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        HashMap conditions = new HashMap();
        HashMap parameters = new HashMap();
        rootObject.getObject("conditions").getSuccess().ifPresent(array -> array.stream().forEach(entry -> Condition.parse((JsonElementWrapper)entry.getValue(), conditionFactories, context).peek(condition -> conditions.put((String)entry.getKey(), (Condition)condition), failures::add)));
        rootObject.getObject("parameters").getSuccess().ifPresent(array -> array.stream().forEach(entry -> Parameter.parse((JsonElementWrapper)entry.getValue(), parameterFactories, context).peek(parameter -> parameters.put((String)entry.getKey(), (Parameter)parameter), failures::add)));
        List calculations = rootObject.getArray("experience").getSuccess().flatMap(array -> array.getAsList((i, element) -> Calculation.parse(element, conditions.keySet(), parameters.keySet())).mapFailure(ManyFailures::ofList).ifFailure(failures::add).getSuccess()).orElseGet(List::of);
        if (failures.isEmpty()) {
            return Result.success(new CalculationManager<T>(conditions, parameters, calculations));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }
}

